(function () {
    var app = angular.module('menu', []);

    app.directive('menu', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/menu.html',
            controller: function ($rootScope, $scope, $timeout) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;

                $scope.$watch('ctrl.view', view => {
                    if(view == null) {
                        ctrl.view = $rootScope.options.hasCompletedWelcome ? null : 'welcome';
                    }
                });

                ctrl.confirmWelcome = () => {
                    $rootScope.options.hasCompletedWelcome = true;
                    $rootScope.saveOptions();
                    ctrl.view = null;
                    wallhack.registerProfile($rootScope.options.clientId, 'sc', $rootScope.options.email);
                };

                ctrl.startGame = function () {
                    ToggleLoader(true);

                    $timeout(() => {
                        $rootScope.setActiveView(null);
                        $rootScope.settings = GetNewSettings();
                        $rootScope.settings.companyName = ctrl.companyName;
                        $rootScope.settings.started = moment(new Date()).set('hours', 8).set('m', 0).set('s', 0).toDate();
                        $rootScope.settings.date = $rootScope.settings.started;
                        $rootScope.options.lastSaveGame = Helpers.GetSaveGameIdentifer($rootScope.settings.id);

                        wallhack.registerProfile($rootScope.options.clientId, 'sc', $rootScope.options.email);

                        $timeout(() => Helpers.ResetEngine()); // Allow settings-watchers to run before resetting

                        $timeout(() => {
                            EmailGenerator.WelcomeMail();
                        }, 6000);

                        $timeout(() => SetZoom(), 1000);
                        $timeout(() => {
                            $rootScope.setActiveView('finance', 'loans');
                            $rootScope.$digest();
                            ToggleLoader(false);
                        }, 3000);

                        wallhack.sendEvent("new_game", ctrl.companyName);
                        Modding._executeEvent('onLoadGame', $rootScope.settings);
                        $rootScope.saveOptions();
                    }, 50);
                };
                ctrl.minimumZoom = Helpers.CalculateMinimumZoom();

                ctrl.toggleFullscreen = function () {
                    $rootScope.options.fullScreen = !$rootScope.options.fullScreen;
                    SetFullScreen($rootScope.options.fullScreen);
                };

                ctrl.toggleAllowRunInBackground = () => {
                    $rootScope.options.allowRunInBackground = !$rootScope.options.allowRunInBackground;
                };

                ctrl.toggleDeveloperMode = () => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_developer_mode'), () => {
                        $rootScope.options.developerMode = !$rootScope.options.developerMode;
                        $rootScope.saveOptions();
                        Remote.app.restart();
                    });
                };

                ctrl.continueGame = () => {
                    $rootScope.setActiveView(null);
                    SetZoom();
                };

                ctrl.exitGame = function () {
                    $rootScope.confirm('', Helpers.GetLocalized('confirm_exit_game'), function () {
                        window.close();
                    });
                };

                let loadSaveGames = () => {
                    ctrl.saveGames = [];
                    Remote.app.getSaveGames(files => {
                        files.forEach(file => {
                            if (_.startsWith(file, `sg_`)) {
                                Helpers.LoadSettingsFromDisk(file, settings => {
                                    ctrl.saveGames.push({
                                            id: settings.id,
                                            companyName: settings.companyName,
                                            gameover: settings.gameover,
                                            fileName: file,
                                            day: Math.round(moment.duration(new Date(settings.date) - settings.started).asDays() + 1)
                                        }
                                    );
                                    $scope.$digest();
                                });
                            }
                        });

                    });
                };
                loadSaveGames();

                ctrl.loadSaveGame = fileName => {
                    ToggleLoader(true);
                    $rootScope.setActiveView(null);
                    $rootScope.options.lastSaveGame = fileName;
                    $rootScope.saveOptions();
                    Helpers.LoadGame($rootScope, fileName, settings => {
                        Modding._executeEvent('onLoadGame', settings);
                        $timeout(() => {
                            SetZoom();
                            ToggleLoader(false);
                        }, 100);
                    });
                };

                ctrl.deleteSaveGame = saveGame => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_delete_savegame'), () => {
                        Remote.app.deleteFile(saveGame.fileName);

                        if ($rootScope.settings != null && saveGame.id == $rootScope.settings.id) {
                            $rootScope.settings = null;
                        }

                        _.remove(ctrl.saveGames, sg => sg.id == saveGame.id);
                    });
                };

                $scope.$watch('ctrl.view', function (newValue, oldValue) {
                    if (oldValue == "options" && newValue != "options") {
                        $rootScope.saveOptions();
                    }
                });

                Remote.app.getMods(result => {
                    ctrl.mods = result;
                });

                ctrl.dirty = false;
                ctrl.uninstall = (mod) => {
                    ctrl.dirty = true;
                    _.remove($rootScope.options.installedMods, x => x == mod);
                    $rootScope.saveOptions();
                };

                ctrl.install = (mod) => {
                    ctrl.dirty = true;
                    $rootScope.options.installedMods.push(mod);
                    $rootScope.saveOptions();
                    RunAchievementTriggers();
                };

                ctrl.isModInstalled = mod => {
                    return $rootScope.options.installedMods.some(x => x == mod);
                };

                ctrl.languages = Database.languages;

                ctrl.language = ctrl.languages.find(x => x.key == $rootScope.options.language);

                ctrl.languageChanged = (selected) => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_change_language'), () => {
                        $rootScope.options.language = selected.key;
                        $rootScope.saveOptions();
                        Remote.app.restart();
                    });
                };

                ctrl.openGithub = () => Remote.app.openLink('http://bugs.startupcompanygame.com');
                ctrl.openDiscord = () => Remote.app.openLink('https://discord.gg/hovgaardgames');
                ctrl.openEula = () => $rootScope.setActiveView('');
            },
            controllerAs: "ctrl"
        }
    });
})();